#include "MAC57D54H.h"
#include "halo_ports.h"

void SDRAM_setup(void);


void SDRAM_setup()
{
  uint32_t i;
  
  MC_CGM.SC_DC0.R = 0x80070000; /* set DDR/SDR div to 8 */ //TEMP
  
  /* configure I/O for SDR */
  for(i=128; i<167; i++)	/* Configure I/O to half strength (PJ0 - PL6)  */
	SIUL2.MSCR[i].R = 0x32080001; //IBE may not be needed
	
  
    MDDRC.SYS_CONFIG.R = 0xF0000000; /* enable */
    MDDRC.SYS_CONFIG.R = 0xFAA29100;  /*CKE enable, CLK enable, CMD mode activated. 
										DRAM row select = 3 = [38:13]
										DRAM bank address = 3 [13:12]
										16bit mode enabled
										Read Delay, half, quarter: 2.0 (0100,1,0)
										WDLY = 0b001
										ODT = off
										*/
										
										 			
    MDDRC.TIME_CONFIG0.R = 0x01901E17; //non optimized */
    MDDRC.TIME_CONFIG1.R = 0x24AA1126; // check these
    MDDRC.TIME_CONFIG2.R = 0x24421042; 
    MDDRC.EX_AT.R = 0x00C00000; /* enabled SDR mode - CAS = 3 */
	
	  //Issue 1 NOP operation while waiting 100 us since clock is stable.
    for(i=0; i<100; i++)
	MDDRC.CMD.R = 0x00380000; 	/* Issue NOP */

    for(i=0; i<20; i++)
    MDDRC.CMD.R = 0x00100400;	/* Precharge All */
    MDDRC.CMD.R = 0x00080000;	/* Issue an AUTO REFRESH */

    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */
    MDDRC.CMD.R = 0x00080000;	/* Issue an AUTO REFRESH */

    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */
	
    MDDRC.CMD.R = 0x00000032;	/* load mode register - CAS=3, burst length = 4 standard - correct for Micron and ISSI */
    
    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */


    MDDRC.SYS_CONFIG.R &= 0xEFFFFFFF;	/* End Command */
  
} /* SDRAM_setup */


